# Comercializame-Keno

Comercializame-Keno es una plataforma moderna para cotizar, comparar y generar envíos para negocios y particulares. El proyecto está compuesto por un frontend desarrollado en Svelte + TypeScript + Vite y un backend API en Laravel.

---

## Estructura del Proyecto

```
/backend-laravel   # Backend API en Laravel
/frontend-svelte   # Frontend en Svelte + Vite
```

---

## Características

### Frontend (Svelte + Vite + Tailwind CSS)

- Interfaz rápida y responsiva para cotizar y gestionar envíos.
- Formularios intuitivos para ingresar datos de paquetes y contacto.
- Secciones de preguntas frecuentes, beneficios y contacto.
- Integración con WhatsApp para soporte directo.
- Diseño moderno con Tailwind CSS.

### Backend (Laravel)

- API RESTful para gestionar solicitudes de envío y datos de usuario.
- Notificaciones por correo electrónico para solicitudes de envío.
- Autenticación segura y gestión de usuarios.
- Migraciones y seeders para fácil despliegue.

---

## Instalación y Uso

### Requisitos

- Node.js (v18+ recomendado)
- PHP (v8.1+ recomendado)
- Composer
- Base de datos (MySQL, SQLite, etc.)

### Backend (Laravel)

1. Instala dependencias:
   ```sh
   cd backend-laravel
   composer install
   npm install
   ```
2. Copia `.env.example` a `.env` y configura tus variables de entorno.
3. Genera la clave de la aplicación:
   ```sh
   php artisan key:generate
   ```
4. Ejecuta migraciones:
   ```sh
   php artisan migrate
   ```
5. Inicia el servidor:
   ```sh
   php artisan serve
   ```

### Frontend (Svelte)

1. Instala dependencias:
   ```sh
   cd frontend-svelte
   npm install
   ```
2. Inicia el servidor de desarrollo:
   ```sh
   npm run dev
   ```
3. Accede a la app en [http://localhost:5173](http://localhost:5173)

---

## Licencia

- El backend Laravel está bajo licencia [MIT](https://opensource.org/licenses/MIT).
- El frontend Svelte también está bajo licencia MIT.

---

¡Personaliza este README con información de despliegue, branding o instrucciones adicionales según tus necesidades!
